<?php
/**
 * Client Close Ticket
 *
 * @package     AutomatorWP\Integrations\Fluent_Support\Triggers\Client_Close_Ticket
 * @author      AutomatorWP <contact@automatorwp.com>, Ruben Garcia <rubengcdev@gmail.com>
 * @since       1.0.0
 */
// Exit if accessed directly
if( !defined( 'ABSPATH' ) ) exit;

class AutomatorWP_Fluent_Support_Client_Close_Ticket extends AutomatorWP_Integration_Trigger {

    public $integration = 'fluent_support';
    public $trigger = 'fluent_support_client_close_ticket';

    /**
     * Register the trigger
     *
     * @since 1.0.0
     */
    public function register() {

        automatorwp_register_trigger( $this->trigger, array(
            'integration'       => $this->integration,
            'label'             => __( 'Client closes a ticket', 'automatorwp-pro' ),
            'select_option'     => __( 'Client <strong>closes</strong> a ticket', 'automatorwp-pro' ),
            /* translators: %1$s: Number of times. */
            'edit_label'        => sprintf( __( 'Client closes a ticket %1$s time(s)', 'automatorwp-pro' ), '{times}' ),
            'log_label'         => __( 'Client closes a ticket', 'automatorwp-pro' ),
            'action'            => 'fluent_support/ticket_closed',
            'function'          => array( $this, 'listener' ),
            'priority'          => 10,
            'accepted_args'     => 1,
            'options'           => array(
                'times' => automatorwp_utilities_times_option()
            ),
            'tags' => array_merge(
                automatorwp_utilities_post_tags( __( 'Ticket', 'automatorwp-pro' ) ),
                automatorwp_utilities_times_tag( )
            )
        ) );

    }

    /**
     * Trigger listener
     *
     * @since 1.0.0
     *
     * @param array $ticket     Data of the ticket we just closed
     */
    public function listener( $ticket ) {

        $ticket_id = absint( $ticket['id'] );
        $closed_by = absint( $ticket['closed_by'] );
        $customer_id = absint( $ticket['customer_id'] );
        $user = get_user_by( 'email', $ticket['customer']['email']);

        // Bail if user not found
        if( ! $user ) {
            return;
        }

        // Bail if ticket was closed by the agent
        if ( $customer_id !== $closed_by ){
            return;
        }

        automatorwp_trigger_event( array(
            'trigger' => $this->trigger,
            'post_id' => $ticket_id,
            'user_id' => $user->ID,
        ) );

    }

}

new AutomatorWP_Fluent_Support_Client_Close_Ticket();